/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于显示硬件卡版本号界面树型控件
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2021.04.27
 *      内容 : 所有代码
 ************************************************************************************************/

// /* global $ */
/* global layui */
/* global mc_sdk_req_mgr */
/* global mc_sdk_param */


// 处理sdk请求; 获取卡连接
var mc_hw_get_card_connect = function () {
    var obj_req_sdk = new mc_sdk_req_mgr();

    // HW_SENDCARD_CONNECT
    this.get_send = function (obj_sdk_param, callback) {
        return this.request("HW_SENDCARD_CONNECT", obj_sdk_param, callback);
    };

    // HW_SENDCARD_VERSION
    this.get_send_version = function (obj_sdk_param, callback) {
        return this.request("HW_SENDCARD_VERSION", obj_sdk_param, callback);
    };

    // HW_HUBCARD_CONNECT
    this.get_hub = function (obj_sdk_param, callback) {
        return this.request("HW_HUBCARD_CONNECT", obj_sdk_param, callback);
    };

    // HW_RECVCARD_CONNECT
    this.get_recvcard = function (obj_sdk_param, callback) {
        return this.request("HW_RECVCARD_CONNECT", obj_sdk_param, callback);
    };

    // HW_HUBCARD_VERSION
    this.get_hub_version = function (obj_sdk_param, callback) {
        return this.request("HW_HUBCARD_VERSION", obj_sdk_param, callback);
    };

    // HW_RECVCARD_VERSION
    this.get_recv_version = function (obj_sdk_param, callback) {
        return this.request("HW_RECVCARD_VERSION", obj_sdk_param, callback);
    };

    // HW_FUNCCARD_VERSION
    this.get_funccard_version = function (obj_sdk_param, callback) {
        return this.request("HW_FUNCCARD_VERSION", obj_sdk_param, callback);
    };

    // Package request
    this.request = function (str_fun, obj_sdk_param, callback) {
        if ("string" !== typeof str_fun || "object" !== typeof obj_sdk_param || "function" !== typeof callback) {
            return false;
        }

        if (obj_sdk_param.constructor !== mc_sdk_param) {
            return callback(true, new mc_sdk_param());
        }

        if ("HW_SENDCARD_CONNECT" !== str_fun && !obj_sdk_param.get_param_cnt() ) {
            return callback(false, obj_sdk_param);
        }

        obj_sdk_param.set_cmd("GET_PARAM");
        obj_sdk_param.set_func(str_fun.toLocaleUpperCase());
        obj_req_sdk.push_req(obj_sdk_param.get_json(), function (res) {
            obj_sdk_param.set_param_clear();
            obj_sdk_param.set_json(res);
            callback(false, obj_sdk_param);
        });

        return true;
    };
};


if ("object" === typeof layui && "function" === typeof layui.define) {
    // 树型结构
    layui.define(["layer", "tree"], callback_layer_tree);
}

function callback_layer_tree(exports) {
    var tree = layui.tree;
    // 外部数据
    var m_o_out_data = {};
    // define tree obj data
    var obj_tree_data = function () {
        this.id = null;
        this.title = "";
        this.length = 0;
        this.version = "";
        // 初始化时是否展开
        this.spread = true;
        this.children = [];
        this.PORT = 0;
    };

    // defined const
    var STR_SYMBOL = " # ";

    // 定义ui 组件树
    var obj_card_version_tree = {
        render: fn_render
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    渲染树型数据方法
     * 参数:
     *    @param { Promise<Object> } o_param 外部传参; 筛选选项
     *    @param { Promise<Function> } callback 回调函数
     * 返回:
     *    @returns { Promise<Boolean> } false === 参数格式错误
     * 例子:
     *    NA
     * 备注:
     *    o_param {
     *    el: 存放数据外部容器,
     *    opt: 筛选数据接收卡类型
     *    done: 执行完毕回调函数
     *    }
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-28
     *       内容 : 所有代码
     ************************************************************************************************/
    function fn_render(o_param) {
        if ("object" !== typeof o_param) {
            return false;
        }

        if (o_param.el) {
            m_o_out_data.el = o_param.el;
            m_o_out_data.opt = o_param.opt;
            m_o_out_data.done = o_param.done;
            init_get_card_data();
            return true;
        }

        return false;
    }

    // @param { Promise<Array> } data 树型控件data数据
    function init(data) {
        tree.render({
            elem: m_o_out_data.el,
            data: data,
            text: {
                none: "<p style='color:red' control_type='nomarl_text' lang_id='MC_LANG_POPOUT_HARDWARE_CONNECT_FAIL_CHECK_HARDWARE'>连接硬件失败，请检查硬件</p>"
            }
        });

        if ("function" === typeof m_o_out_data.done) {
            m_o_out_data.done();
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    初始化获取卡数据
     * 参数:
     *    NA
     * 返回:
     *    @returns { Promise<String> } true
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-29
     *       内容 : 所有代码
     ************************************************************************************************/
    function init_get_card_data() {
        var m_obj_sdk_connect = new mc_hw_get_card_connect();
        // tree data
        var m_arr_tree_data = [];
        // 全局id
        var m_ui_id = 0;
        // 发送卡下标
        var M_UI_SEND_IDX = 0;


        // send card connect
        m_obj_sdk_connect.get_send(new mc_sdk_param(), function (err, o_sdk_send) {
            var ui_param_cnt = o_sdk_send.get_param_cnt();
            var str_code_name = o_sdk_send.get_param_name(0);

            if (1 === ui_param_cnt && "ERROR_CODE" === str_code_name) {
                init(m_arr_tree_data);
                return;
            }

            // sdk param send version
            var obj_sdk_send_version = new mc_sdk_param();
            var ui_send_i = 0;
            var arr_name_port = "";

            for (var idx = 0; idx < ui_param_cnt; idx++) {
                var str_name = o_sdk_send.get_param_name(idx);
                var str_val = o_sdk_send.get_param_value(str_name);

                if ("ERROR_CODE" === str_name) {
                    continue;
                }

                if (str_val && -1 !== str_val.indexOf(":") && (arr_name_port = get_hub_name_and_port(str_val))) {
                    create_card_tree_data(m_arr_tree_data, ui_send_i, arr_name_port[0] ,"SEND");
                    obj_sdk_send_version.set_param_value(ui_send_i + "", arr_name_port[0].NAME);
                    ui_send_i++;
                }
            }

            if (0 === m_arr_tree_data.length) {
                init(m_arr_tree_data);
                return;
            }

            m_obj_sdk_connect.get_send_version(obj_sdk_send_version, function (err_ver, o_sdk_send_ver) {
                parse_version_json("SEND", o_sdk_send_ver);
                fn_loop_get_data(M_UI_SEND_IDX);
            });
        });


        // 循环获取数据
        function fn_loop_get_data(ui_send_i) {
            if (ui_send_i < m_arr_tree_data.length) {
                get_hub_data(ui_send_i, fn_next_send);
                return;
            }

            init(m_arr_tree_data);
        }

        // 下一个发送卡; 获取发送卡下一个输出口下的hub卡;
        function fn_next_send() {
            M_UI_SEND_IDX++;
            fn_loop_get_data(M_UI_SEND_IDX);
        }


        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    获取hub数据
         * 参数:
         *    @param { Promise<String> } UI_SEND_IDX 当前发送卡下标
         *    @param { Promise<Function> } callback_next 回调函数
         * 返回:
         *    NA
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-30
         *       内容 : 所有代码
        ************************************************************************************************/
        function get_hub_data(UI_SEND_IDX, callback_next) {
            var arr_send_port = m_arr_tree_data[UI_SEND_IDX];
            var ui_send_port_num = arr_send_port.PORT;
            var obj_sdk_param_hub = new mc_sdk_param();

            set_get_connect_req_param(obj_sdk_param_hub, UI_SEND_IDX, Number(ui_send_port_num));

            // 获取发送卡端口下的hub
            m_obj_sdk_connect.get_hub(obj_sdk_param_hub, function callback_hub_connect(err, o_sdk_hub) {
                // 获取hub版本号
                var obj_param_hub_version = new mc_sdk_param();
                var ui_cnt = o_sdk_hub.get_param_cnt();
                var arr_name_port = "";
                var obj_param_recv = new mc_sdk_param();

                // save hub and name
                for (var i = 0; i < ui_cnt; i++) {
                    var s_name = o_sdk_hub.get_param_name(i);
                    var s_val = o_sdk_hub.get_param_value(s_name);
                    // 多张hub卡
                    var s_hub = o_sdk_hub.get_attr_val(s_name, "STATUS");

                    if (s_hub && s_val && (arr_name_port = get_hub_name_and_port(s_hub))) {
                        var arr_i = get_idx(s_val);
                        var ui_hub_len = arr_name_port.length;

                        // 单个port下的hub
                        for (var hub_i = 0; hub_i < ui_hub_len; hub_i++) {
                            var hub_item = arr_name_port[hub_i];
                            var s_hub_idx = s_val + ":" + hub_i;

                            create_card_tree_data(arr_send_port.children[arr_i[1]].children, hub_i, hub_item, "HUB");
                            // 保存请求接收参数
                            obj_param_hub_version.set_param_value(s_hub_idx, hub_item.NAME);

                            if (0 < hub_item.PORT) {
                                set_get_connect_req_param(obj_param_recv, s_hub_idx, hub_item.PORT);
                            }
                        }
                    }
                }

                // 获取hub版本号
                m_obj_sdk_connect.get_hub_version(obj_param_hub_version, function (hub_ver_err, o_sdk_hub_version) {
                    parse_version_json("HUB", o_sdk_hub_version);
                    // 处理接收卡请求
                    deal_recvcard_connect(obj_param_recv, true);
                });
            });


            /************************************************************************************************
             * 类型:
             *    函数
             * 功能:
             *    处理接收卡连接
             * 参数:
             *    @param { Promise<Object> } o_sdk_param 接收卡请求参数对象
             *    @param { Promise<Boolean> } b_hub 是否是hub下的接收卡
             * 返回:
             *    NA
             * 例子:
             *    NA
             * 备注:
             *    NA
             * 修改:
             *    1. 类型 : 创建
             *       作者 : 巫昭雯
             *       时间 : 2021-04-30
             *       内容 : 所有代码
             ************************************************************************************************/
            function deal_recvcard_connect(o_sdk_param, b_hub) {
                m_obj_sdk_connect.get_recvcard(o_sdk_param, function (err, o_sdk_recv) {
                    var ui_recv_cnt = o_sdk_recv.get_param_cnt();
                    var obj_param_recv_version = new mc_sdk_param();
                    var obj_param_recv_version_func = new mc_sdk_param();

                    for (var recv_i = 0; recv_i < ui_recv_cnt; recv_i++) {
                        var s_recv_name = o_sdk_recv.get_param_name(recv_i);
                        var s_recv_val = o_sdk_recv.get_param_value(s_recv_name);
                        var s_recv_status = o_sdk_recv.get_attr_val(s_recv_name, "STATUS");
                        var ui_recv_num = judge_recvcard(s_recv_status);

                        if (s_recv_val && "object" === typeof ui_recv_num) {
                            var arr_recv_index = get_idx(s_recv_val);

                            if (b_hub) {
                                create_recvcard_tree_data(arr_send_port.children[arr_recv_index[1]].children[arr_recv_index[2]].children[arr_recv_index[3]], ui_recv_num, s_recv_val, obj_param_recv_version, obj_param_recv_version_func);
                            } else {
                                create_recvcard_tree_data(arr_send_port.children[arr_recv_index[1]], ui_recv_num, s_recv_val + ":0:0", obj_param_recv_version, obj_param_recv_version_func);
                            }
                        }
                    }

                    req_get_recv_version(obj_param_recv_version, obj_param_recv_version_func);
                });


                /************************************************************************************************
                 * 类型:
                 *    函数
                 * 功能:
                 *    请求获取接收卡版本号
                 * 参数:
                 *    @param { Promise<Object> } obj_param_recv_version   mc_sdk_param 实例对象; 获取接收卡版本请求参数; 接收卡类型 !== "多功能卡"
                 *    @param { Promise<Object> } obj_param_recv_version_func mc_sdk_param 实例对象; 获取接收卡版本请求参数;; 接收卡类型 === "多功能卡"
                 * 返回:
                 *    NA
                 * 例子:
                 *    NA
                 * 备注:
                 *    NA
                 * 修改:
                 *    1. 类型 : 创建
                 *       作者 : 巫昭雯
                 *       时间 : 2021-04-30
                 *       内容 : 所有代码
                ************************************************************************************************/
                function req_get_recv_version(obj_param_recv_version, obj_param_recv_version_func) {
                    // 获取接收卡和多功能卡版本号
                    m_obj_sdk_connect.get_recv_version(obj_param_recv_version, function (recv_err, o_sdk_recv_ver) {
                        package_add_recv_version(o_sdk_recv_ver);
                        m_obj_sdk_connect.get_funccard_version(obj_param_recv_version_func, function (func_err, o_sdk_func_ver) {
                            package_add_recv_version(o_sdk_func_ver);

                            if (b_hub) {
                                // 获取发送卡下的接收卡
                                var obj_sdk_send_recv = new mc_sdk_param();

                                set_get_connect_req_param(obj_sdk_send_recv, UI_SEND_IDX, Number(ui_send_port_num));
                                deal_recvcard_connect(obj_sdk_send_recv, false);
                            } else {
                                // 获取发送卡下一个输出口下的hub卡;
                                if ("function" === typeof callback_next) {
                                    callback_next();
                                }
                            }
                        });
                    });
                }


                /************************************************************************************************
                 * 类型:
                 *    函数
                 * 功能:
                 *    封装添加接收卡版本; 此函数为了保存区分的 "多功能卡" 和 "接收卡" 请求
                 * 参数:
                 *    @param { Promise<Object> } o_sdk_ver 请求版本回传接收卡版本字串 mc_sdk_param 实例对象
                 * 返回:
                 *    NA
                 * 例子:
                 *    NA
                 * 备注:
                 *    NA
                 * 修改:
                 *    1. 类型 : 创建
                 *       作者 : 巫昭雯
                 *       时间 : 2021-04-30
                 *       内容 : 所有代码
                 ************************************************************************************************/
                function package_add_recv_version(o_sdk_ver) {
                    // save recv version
                    if (b_hub) {
                        parse_version_json("HUBRECV", o_sdk_ver);
                    } else {
                        parse_version_json("SENDRECV", o_sdk_ver);
                    }
                }
            }
        }


        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    设置获取卡连接请求参数; 获取hub卡连接和获取接收卡连接
         * 参数:
         *    @param { Promise<Object> } o_sdk_param mc_sdk_param 实例对象
         *    @param { Promise<String> } card_i  卡下标前缀
         *    @param { Promise<String> } port_num 端口个数
         * 返回:
         *    NA
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-29
         *       内容 : 所有代码
         ************************************************************************************************/
        function set_get_connect_req_param(o_sdk_param, card_i, port_num) {
            if ("object" === typeof o_sdk_param && o_sdk_param.constructor === mc_sdk_param) {
                for (var i = 0; i < port_num; i++) {
                    var str_card_idx = card_i + ":" + i;

                    o_sdk_param.set_param_value(str_card_idx, str_card_idx);
                }
            }
        }

        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    创建卡数据; 在此函数内创建卡端口
         * 参数:
         *    @param { Promise<Array> } a_parents 父级数组;
         *    @param { Promise<String> } idx 当前数据在父级的下标
         *    @param { Promise<Object> } o_card 卡数据 { NAME:卡注册名称；PORT:端口数量 }
         *    @param { Promise<String> } s_card_type 卡类型; 参数与 get_title_span 传参一致
         *    @param { Promise<String> } s_version 版本号 (可为空)
         * 返回:
         *    NA
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-30
         *       内容 : 所有代码
        ************************************************************************************************/
        function create_card_tree_data(a_parents, idx, o_card, s_card_type, s_version) {
            if ("object" !== typeof a_parents || "object" !== typeof o_card || "string" !== typeof s_card_type) {
                return;
            }

            s_version = s_version || "";

            var obj_item = new obj_tree_data();

            m_ui_id++;
            obj_item.id = m_ui_id;
            obj_item.title = get_title_span(s_card_type) + (idx + 1) + STR_SYMBOL + o_card.NAME + STR_SYMBOL + s_version;
            obj_item.version = s_version;
            obj_item.PORT = o_card.PORT || 0;
            create_port_arr(obj_item.children, o_card.PORT);
            a_parents[idx] = obj_item;
        }

        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    创建端口树型数据对象;
         * 参数:
         *    @param { Promise<Array> } arr 端口children数组
         *    @param { Promise<String> } num 端口个数
         * 返回:
         *    NA
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-30
         *       内容 : 所有代码
        ************************************************************************************************/
        function create_port_arr(arr, num) {
            if ("object" !== typeof arr) {
                return;
            }

            for (var i = 0; i < num; i++) {
                var obj_tree_i = new obj_tree_data();

                m_ui_id++;
                obj_tree_i.id = m_ui_id;
                obj_tree_i.title = get_title_span("PORT") + (i + 1);
                arr[i] = obj_tree_i;
            }
        }


        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    判断接收卡连接类型
         * 参数:
         *    @param { Promise<String> } str 接收卡连接返回json字串 "STATUS" 属性值;
         * 返回:
         *    @returns { Promise<Object> } obj_res 返回连接的接收卡对象 || false === 参数错误或为连接接收卡
         * 例子:
         *    NA
         * 备注:
         *    返回对象属性解释 : {
         *      T6 : T6 卡数量
         *      MUTIL : MUTIL 卡数量
         *      FPGA : FPGA 卡数量
         *      NUM : 所有接收卡总和
         *   }
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-30
         *       内容 : 所有代码
        ************************************************************************************************/
        function judge_recvcard(str) {
            if ("string" === typeof str) {
                var ui_i = str.lastIndexOf(":");
                var ui_num = Number(str.substring(ui_i + 1, str.length));

                if (ui_num) {
                    var obj_res = {};
                    var arr_param = str.split(":");

                    obj_res.T6 = Number(arr_param[0]);
                    obj_res.MUTIL = Number(arr_param[1]);
                    obj_res.FPGA = Number(arr_param[2]);
                    obj_res.NUM = ui_num;
                    return obj_res;
                }

                return false;
            }
            return false;
        }


        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    接收卡处理:构造接收卡tree data && 设置请求获取版本号参数;
         * 参数:
         *    @param { Promise<Array> } arr 保存接收卡的父级容器; port空对象
         *    @param { Promise<Object> } obj 各种接收卡类型对象
         *    @param { Promise<String> } str 请求父级字符串前缀; "0:0" === "发送卡下" || "0:1:0:1" === "hub卡下"
         *    @param { Promise<Object> } obj_sdk mc_sdk_param 实例对象: 接收卡类型 !== 多功能卡;
         *    @param { Promise<Object> } obj_sdk_func mc_sdk_param 实例对象: 获取接收卡类型 === 多功能卡
         * 返回:
         *    NA
         * 例子:
         *    NA
         * 备注:
         *    FPGA : 请求值名称有 "MINI" || "V3" || "FPGA"
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-29
         *       内容 : 所有代码
         ************************************************************************************************/
        function create_recvcard_tree_data(arr, obj, str, obj_sdk, obj_sdk_func) {
            if ("object" !== typeof arr || "object" !== typeof obj || "object" !== typeof obj_sdk || "object" !== typeof obj_sdk_func) {
                return;
            }

            if ("object" !== typeof arr.children || obj_sdk.constructor !== mc_sdk_param || obj_sdk_func.constructor !== mc_sdk_param) {
                return;
            }

            // T6
            for (var i_t6 = 0; i_t6 < obj.T6; i_t6++) {
                var obj_t6 = new obj_tree_data();

                m_ui_id++;
                obj_t6.id = m_ui_id;
                obj_t6.title = get_title_span("RECV") + (i_t6 + 1) + STR_SYMBOL + "T6" + STR_SYMBOL;
                arr.children[i_t6] = obj_t6;
                obj_sdk.set_param_value(str + ":" + i_t6, "T6");
            }

            // 多功能卡
            var ui_mulri_end = obj.MUTIL + obj.T6;

            for (var i_multi = obj.T6; i_multi < ui_mulri_end; i_multi++) {
                var obj_mul = new obj_tree_data();

                m_ui_id++;
                obj_mul.id = m_ui_id;
                obj_mul.title = get_title_span("RECV") + (i_multi + 1) + STR_SYMBOL + "多功能卡" + STR_SYMBOL;
                arr.children[i_multi] = obj_mul;
                obj_sdk_func.set_param_value(str + ":" + i_multi, "");
            }

            // FPGA
            var ui_fpga_s = obj.T6 + obj.MUTIL;
            var ui_fpga_end = obj.T6 + obj.MUTIL + obj.FPGA;

            for (var i_fpga = ui_fpga_s; i_fpga < ui_fpga_end; i_fpga++) {
                var obj_fpga = new obj_tree_data();

                m_ui_id++;
                obj_fpga.id = m_ui_id;
                obj_fpga.title = get_title_span("RECV") + (i_fpga + 1) + STR_SYMBOL + m_o_out_data.opt + STR_SYMBOL;
                arr.children[i_fpga] = obj_fpga;
                obj_sdk.set_param_value(str + ":" + i_fpga, m_o_out_data.opt);
            }
        }


        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    解析下标
         * 参数:
         *    @param { Promise<String> } str 卡字符串; eg: "0:2:1:4"
         * 返回:
         *    @returns { Promise<Array> } 清除":" && 转化为数组
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-30
         *       内容 : 所有代码
        ************************************************************************************************/
        function get_idx(str) {
            if ("string" === typeof str) {
                var res = str.trim().replace("(", "").replace(")", "").split(":");

                return res;
            }

            return false;
        }


        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    获取hub注册名称和端口数量
         * 参数:
         *    @param { Promise<String> } str hub连接返回value值
         * 返回:
         *    @returns { Promise<Array> } 多张hub卡数组; 内置对象属性 { NAME: hub注册名称, PORT: hub卡端口 }
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-29
         *       内容 : 所有代码
         ************************************************************************************************/
        function get_hub_name_and_port(str) {
            if ("string" === typeof str && -1 !== str.indexOf(":")) {
                var arr_res = [];
                var arr = str.split(",");

                for (var idx = 0; idx < arr.length; idx++) {
                    arr_res.push({
                        NAME: arr[idx].split(":")[0],
                        PORT: Number(arr[idx].split(":")[1])
                    });
                }

                return arr_res;
            }

            return false;
        }


        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    解析版本号返回字串 json;
         * 参数:
         *    @param { Promise<String> } s_card_type 卡类型；与 update_title_add_version 卡类型传参一致
         *    @param { Promise<Object> } o_version_sdk 卡版本sdk实例对象
         * 返回:
         *    NA
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-05-06
         *       内容 : 所有代码
        ************************************************************************************************/
        function parse_version_json(s_card_type, o_version_sdk) {
            if ("string" === typeof s_card_type && "object" === typeof o_version_sdk && o_version_sdk.constructor === mc_sdk_param) {
                var ui_ver_cnt = o_version_sdk.get_param_cnt();

                s_card_type = s_card_type.toLocaleUpperCase().trim();

                for (var idx = 0; idx < ui_ver_cnt; idx++) {
                    var s_name = o_version_sdk.get_param_name(idx);
                    var s_value = o_version_sdk.get_param_value(s_name);

                    if ("ERROR_CODE" !== s_name) {
                        // save version
                        update_title_add_version(s_card_type, s_value, get_idx(s_name));
                    }
                }
            }
        }

        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    读取版本更新title值
         * 参数:
         *    @param { Promise<String> } s_card_type 卡类型; 参数说明参考备注
         *    @param { Promise<String> } str_version 添加的版本号字符串
         *    @param { Promise<Array> } arr_i 卡下标数组
         * 返回:
         *    NA
         * 例子:
         *    NA
         * 备注:
         *    SEND === 发送卡
         *    HUB === HUB卡
         *    SENDRECV === 发送卡下的接收卡
         *    HUBRECV === hub下的接收卡
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-04-30
         *       内容 : 所有代码
        ************************************************************************************************/
        function update_title_add_version(s_card_type, str_version, arr_i) {
            if ("string" !== typeof s_card_type || "object" !== typeof arr_i || "undefined" === typeof arr_i[0]) {
                return;
            }

            try {
                update_title();
            } catch (error) {
                // console.log(error);
            }

            function update_title() {
                var ui_i_send = arr_i[0] || 0;
                var ui_i_send_port = arr_i[1] || 0;
                var ui_i_hub = arr_i[2] || 0;
                var ui_i_hub_port = arr_i[3] || 0;
                var ui_i_recv = arr_i[4] || 0;

                switch (s_card_type.toLocaleUpperCase()) {
                case "SEND":
                    m_arr_tree_data[ui_i_send].title += str_version;
                    break;
                case "HUB":
                    m_arr_tree_data[ui_i_send].children[ui_i_send_port].children[ui_i_hub].title += str_version;
                    break;
                case "HUBRECV":
                    m_arr_tree_data[ui_i_send].children[ui_i_send_port].children[ui_i_hub].children[ui_i_hub_port].children[ui_i_recv].title += str_version;
                    break;
                case "SENDRECV":
                    m_arr_tree_data[ui_i_send].children[ui_i_send_port].children[ui_i_recv].title += str_version;
                    break;
                default:
                    return;
                }
            }

            return;
        }

        return true;
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取标题span 标签字符串
     * 参数:
     *    @param { Promise<String> } card_type 卡类型字符串

     * 返回:
     *    @returns { Promise<String> }
     * 例子:
     *    NA
     * 备注:
     *    card_type 取值: SEND === "发送卡" || "HUB" === "HUB卡" || "REDV" === "接收卡" || "PORT" === "端口"
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-30
     *       内容 : 所有代码
    ************************************************************************************************/
    function get_title_span(card_type) {
        if ("string" !== typeof card_type) {
            return "";
        }

        switch (card_type.toLocaleUpperCase()) {
        case "SEND":
            return "<span control_type='nomarl_text' lang_id='MC_LANG_BTN_SCREEN_SENDING_CARD'>主控</span>";
        case "HUB":
            return "<span control_type='nomarl_text' lang_id='MC_LANG_HUB_CARD'>分控</span>";
        case "RECV":
            return "<span control_type='nomarl_text' lang_id='MC_LANG_RECEIVER_CARD'>接收卡</span>";
        case "PORT":
            return "<span control_type='nomarl_text' lang_id='MC_LANG_DISP_PORT'>端口</span>";
        default:
            return "";
        }
    }

    exports("card_version_tree", obj_card_version_tree);
}
